'use strict';

function GroupsCtrl($scope, $rootScope, $route, $location, GroupsManager, GroupsRoundsManager, NavigationItems, AppConfig, UserLogManager, GroupResults){
    $scope.groups = $route.current.locals.groups;

    $scope.calculateCurrentRounds = function() {
        angular.forEach($scope.groups, function(group){
            group.currentRoundNumber = 1;
            angular.forEach(group.rounds, function(round)
            {
                if(round.is_done)
                    group.currentRoundNumber++;
            })
        });
    };
    $scope.calculateCurrentRounds();

    $scope.resetGroupButtonEnabled = function(group){
        return !group.was_reset && (group.currentRoundNumber <= 3 || group.currentRoundNumber >= 8);
    };

    $scope.$on('Groups:saveGroup', function(event, group){
        GroupsManager.setGroup(group);
        GroupsRoundsManager.clearAll();
        UserLogManager._isLoadedData = false;
        GroupResults._isLoadedData = false;
    });


    /**
     * Zmienia zaznaczenie przy studencie
     *
     * @param student
     */
    $scope.toggleCheckStudent = function(student){
        (student.isSelected()) ? student.unselect() : student.select();
    }


    /**
     * Sprawdza czy jakikolwiek uczestnik jest zaznaczony
     *
     * @param group
     * @returns {boolean}
     */
    $scope.isAnyStudentSelected = function(group){
        for(var i = 0; i < group.users.length; i++)
        {
            if(group.users[i].isSelected())
            {
                return true;
            }
        }

        return false;
    }

    /**
     * Sprawdza czy wszyscy uczestnicy są zazanaczeni
     *
     * @param group
     * @returns {boolean}
     */
    $scope.isAllStudentsSelected = function(group){
        for(var i = 0; i < group.users.length; i++)
        {
            if(!group.users[i].isSelected())
            {
                return false;
            }
        }
        return (group.users.length > 0) ? true : false;
    }

    /**
     * Zaznacza albo odznacza listę wszystkich uczestników
     *
     * @param group
     */
    $scope.selectAllStudents = function(group){
        var selectAll = !$scope.isAllStudentsSelected(group);
        for(var i = 0; i < group.users.length; i++)
        {
            group.users[i]._selected = selectAll;
        }
    }


    /**
     * Otwiera okno dodwania grupy
     */
    $scope.addGroup = function(){
        var group = {
            id: 0
            ,name: ''
            ,users: [
//                {
//                    id: 1
//                    ,name: 'Jan'
//                    ,surname: 'Kowaslki'
//                    ,email: 'jan.kowalski@vm.pl'
//                }
            ]
        }

        if(!$scope.isMaxGroupUsers(group))
        {
            $rootScope.$broadcast('Groups:openGroupModal', group);
        }
    }


    /**
     * Otwiera okno edycji grupy
     *
     * @param group
     */
    $scope.editGroup = function(group){
        $rootScope.$broadcast('Groups:openGroupModal', group);
    }


    /**
     * Dodaje uczestnika
     * @param group
     */
    $scope.addStudent = function(group){
        var student = {
            id: 0
            ,name: ''
            ,surname: ''
            ,email: ''
        }
        $rootScope.$broadcast('Groups:openStudentModal', {
            group: group
            ,student: student
        });
    }


    /**
     * Otwiera okno edycji uczestnika
     * @param group
     * @param student
     */
    $scope.editStudent = function(group, student){
        $rootScope.$broadcast('Groups:openStudentModal', {
            group: group
            ,student: student
        });
    }

    /**
     * Otwiera okno z pytaniem o usuniecie użytkownika
     * @param group
     * @param student
     */
    $scope.removeStudentWarning = function(group, student){
        $rootScope.$broadcast('Groups:removeStudentModal',{
            group: group
            ,student: student
        });
    }


    $scope.removeSelectedStudentsWarning = function(group){
        var students = group.getSelectedUsers();
        if(students.length == 1)
        {
            $scope.removeStudentWarning(group, students[0]);
        }
        else
        {
            $rootScope.$broadcast('Groups:removeSelectedStudentsModal',group);
        }
    }


    $scope.isMaxGroupUsers = function(group){
        return (group.users.length >= AppConfig.maxNumberOfUsersInGroup);
    }


    $scope.openUserTokenWindow = function(user){
        $rootScope.$broadcast('Groups:openUserTokensWindow', user);
    }


    $scope.removeGroup = function(group){
        $rootScope.$broadcast('Groups:openRemoveGroupModal', group);
    }

    $scope.resetGroup = function(group){
        $rootScope.$broadcast('Groups:openResetGroupModal', group);
    }

}

GroupsCtrl.$inject = ['$scope', '$rootScope', '$route', '$location', 'GroupsManager', 'GroupsRoundsManager', 'NavigationItems', 'AppConfig', 'UserLogManager', 'GroupResults'];